/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.monitor.globalsetting.service.impl;

import com.tp_link.eap.domain.eap.Ap;
import com.tp_link.eap.domain.eap.bean.SsidOverride;
import com.tp_link.eap.domain.eapsetting.MacFilterAssocConfig;
import com.tp_link.eap.domain.eapsetting.SchedulerAssocConfig;
import com.tp_link.eap.domain.eapsetting.SsidC;
import com.tp_link.eap.domain.eapsetting.SsidConfig;
import com.tp_link.eap.domain.eapsetting.SsidRateLimit;
import com.tp_link.eap.domain.eapstats.DeviceMisc;
import com.tp_link.eap.domain.globalsetting.Ssid;
import com.tp_link.eap.domain.globalsetting.WlanGroup;
import com.tp_link.eap.domain.globalsetting.bean.RateLimit;
import com.tp_link.eap.domain.message.body.EapConfigBody;
import com.tp_link.eap.domain.record.SettingRecord;
import com.tp_link.eap.domain.ui.Grid;
import com.tp_link.eap.domain.ui.QueryData;
import com.tp_link.eap.domain.ui.QueryFilter;
import com.tp_link.eap.domain.ui.QueryPage;
import com.tp_link.eap.domain.ui.QuerySort;
import com.tp_link.eap.monitor.globalsetting.model.MacFilterAssociationInfo;
import com.tp_link.eap.monitor.globalsetting.model.SchedulerAssociationInfo;
import com.tp_link.eap.monitor.globalsetting.model.SsidModel;
import com.tp_link.eap.monitor.globalsetting.repo.MongoSequenceRepository;
import com.tp_link.eap.monitor.globalsetting.repo.SsidRepository;
import com.tp_link.eap.monitor.globalsetting.repo.SubnetRepository;
import com.tp_link.eap.monitor.globalsetting.repo.WlanGroupRepository;
import com.tp_link.eap.monitor.globalsetting.service.g;
import com.tp_link.eap.monitor.globalsetting.service.impl.GlobalSettingService;
import com.tp_link.eap.monitor.globalsetting.service.l;
import com.tp_link.eap.monitor.globalsetting.service.n;
import com.tp_link.eap.monitor.portal.service.b;
import com.tp_link.eap.multicontrol.ControlType;
import com.tp_link.eap.multicontrol.OperationResponse;
import com.tp_link.eap.multicontrol.ResErrorCode;
import com.tp_link.eap.util.a.e;
import com.tp_link.eap.util.p.a;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.validation.Validator;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="ssidSettingService")
public class SsidSettingService
extends com.tp_link.eap.i.a.a<Ssid>
implements l {
    @Autowired
    private SsidRepository a;
    @Autowired
    private MongoSequenceRepository b;
    @Autowired
    private SubnetRepository c;
    @Autowired
    private g d;
    @Autowired
    private com.tp_link.eap.monitor.monitor.service.b e;
    @Autowired
    private com.tp_link.eap.monitor.record.service.a f;
    @Autowired
    private b g;
    @Autowired
    private n h;
    @Autowired
    private WlanGroupRepository i;
    @Autowired
    private GlobalSettingService j;
    @Autowired
    private com.tp_link.eap.monitor.site.service.a k;
    @Autowired
    private Validator validator;
    private Logger l = LoggerFactory.getLogger(this.getClass());

    @Override
    public List<Ssid> getSsid2gList() {
        return com.tp_link.eap.util.a.a.a(this.a.findByBandAndSite("2.4GHz", com.tp_link.eap.d.b.a()));
    }

    @Override
    public List<Ssid> getSsid5gList() {
        return com.tp_link.eap.util.a.a.a(this.a.findByBandAndSite("5GHz", com.tp_link.eap.d.b.a()));
    }

    @Override
    public List<Ssid> getAll() {
        return com.tp_link.eap.util.a.a.a(this.a.findAll());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse saveSsid(Ssid ssid, int ssidOper, boolean sendMessage, String overrideName) {
        Object object;
        block35: {
            Integer n2;
            boolean bl;
            block37: {
                block36: {
                    Ssid ssid2;
                    bl = false;
                    int n3 = 0;
                    String string = "";
                    if (ssid == null) {
                        return com.tp_link.eap.util.e.aZ;
                    }
                    Integer n4 = 3;
                    n2 = 0;
                    if ("2.4GHz".equalsIgnoreCase(ssid.getBand())) {
                        n2 = 0;
                    } else if ("5GHz".equalsIgnoreCase(ssid.getBand())) {
                        n2 = 1;
                    } else {
                        return com.tp_link.eap.util.e.aZ;
                    }
                    ssid.setRadioId(n2.intValue());
                    Ssid ssid3 = null;
                    String string2 = com.tp_link.eap.d.b.a();
                    if (com.tp_link.eap.util.a.e.a((String)string2)) {
                        this.l.error("Failed to find curent site to saveSsid");
                        return new OperationResponse(ResErrorCode.r);
                    }
                    object = com.tp_link.eap.b.b.a.l((String)string2);
                    synchronized (object) {
                        com.tp_link.eap.d.b.g((String)string2);
                        if (!this.k.siteNameAlreadyExist(string2)) {
                            this.l.warn("Invalid sitName.");
                            com.tp_link.eap.b.b.a.m((String)string2);
                            return new OperationResponse(ResErrorCode.r);
                        }
                        if (ssid.getId() == null) {
                            if (this.a.countBySiteAndRadioIdAndWlanId(string2, n2, ssid.getWlanId()) >= (long)com.tp_link.eap.util.e.bA.intValue()) {
                                return new OperationResponse(ResErrorCode.z);
                            }
                            ssid3 = this.a.findByBandAndNameAndSiteAndWlanId(n2 == 0 ? "2.4GHz" : "5GHz", ssid.getName(), string2, ssid.getWlanId());
                            if (ssid3 != null) {
                                OperationResponse operationResponse = new OperationResponse(ResErrorCode.A);
                                operationResponse.setMsg(String.format("SSID with name %s is already existed, can not create.", ssid.getName()));
                                return operationResponse;
                            }
                            n4 = 1;
                            ssid.setIdInt(this.b.getSequenceStartNumber("Ssid"));
                            bl = true;
                            n3 = 2;
                        } else {
                            ssid3 = this.a.findByBandAndNameAndSiteAndWlanId(n2 == 0 ? "2.4GHz" : "5GHz", ssid.getName(), string2, ssid.getWlanId());
                            if (ssid3 != null && !ssid.getId().equals(ssid3.getId())) {
                                OperationResponse operationResponse = new OperationResponse(ResErrorCode.A);
                                operationResponse.setMsg(String.format("SSID with name %s is already existed, can not rename.", ssid.getName()));
                                return operationResponse;
                            }
                            ssid3 = (Ssid)this.a.findOne((Serializable)((Object)ssid.getId()));
                            if (ssid3 == null) {
                                return new OperationResponse(ResErrorCode.B);
                            }
                            ssid.setId(ssid3.getId());
                            ssid.setIdInt(ssid3.getIdInt());
                            if (overrideName != null) {
                                n3 = 2;
                                string = overrideName;
                            } else {
                                n3 = this.a(ssid3, ssid, ssidOper);
                                string = ssid3.getName();
                            }
                            this.l.debug("SSID RefreshBasicInfo: {}", (Object)n3);
                            if (this.a(ssid3.getRateLimit(), ssid.getRateLimit())) {
                                bl = true;
                            }
                        }
                        if (ssid.getSecurityMode() == 1 && (ssid2 = this.a.findByRadioIdAndSecurityModeAndSiteAndWlanId(n2, 1, string2, ssid.getWlanId())) != null && !ssid2.getId().equals(ssid.getId())) {
                            return new OperationResponse(ResErrorCode.C);
                        }
                        ssid2 = this.b(ssid);
                        if (ssid2 != null && !com.tp_link.eap.util.a.e.a((String)ssid.getPortalId(), (String)ssid2.getPortalId())) {
                            ssid.setPortalId(ssid2.getPortalId());
                            this.g.delAllGuestBySsid(ssid.getName(), ssid.getWlanId(), n2);
                        }
                        ssid.setSite(string2);
                        ssid = (Ssid)this.a.save(ssid);
                        this.e.refreshApSsid(ssid, n4);
                    }
                    if (!sendMessage) break block35;
                    if (n3 <= 0) break block36;
                    object = Collections.singletonList(ssid.getId());
                    ssid2 = null;
                    SchedulerAssocConfig schedulerAssocConfig = null;
                    MacFilterAssocConfig macFilterAssocConfig = null;
                    List<Ap> list = this.e.getSiteAndWlanAdoptedAps(com.tp_link.eap.d.b.a(), ssid.getWlanId());
                    switch (ssidOper) {
                        case 0: {
                            ssid2 = this.d.a((int)n4, n2, (List<String>)object);
                            ((SsidC)ssid2.getSsid().get(0)).setOldSsidName(string);
                            schedulerAssocConfig = this.d.a((List<String>)object);
                            macFilterAssocConfig = this.d.c((List<String>)object);
                            this.f.refreshRecord("schedulerAssoc", schedulerAssocConfig);
                            this.f.refreshRecord("macFilterAssoc", macFilterAssocConfig);
                            if (n2 == 0) {
                                this.f.refreshRecord("ssid_2G", ssid2, list);
                            } else {
                                this.f.refreshRecord("ssid_5G", ssid2, list);
                            }
                            if (n3 == 3) {
                                this.g.delAllGuestBySsid(ssid.getName(), ssid.getWlanId(), n2);
                                break;
                            }
                            break block37;
                        }
                        case 1: {
                            ssid2 = this.d.a((int)n4, n2, (List<String>)object);
                            ((SsidC)ssid2.getSsid().get(0)).setOldSsidName(string);
                            if (n2 == 0) {
                                this.f.refreshRecord("ssid_2G", ssid2, list);
                            } else {
                                this.f.refreshRecord("ssid_5G", ssid2, list);
                            }
                            if (n3 == 3) {
                                this.g.delAllGuestBySsid(ssid.getName(), ssid.getWlanId(), n2);
                                break;
                            }
                            break block37;
                        }
                        case 2: {
                            macFilterAssocConfig = this.d.c((List<String>)object);
                            this.f.refreshRecord("macFilterAssoc", macFilterAssocConfig, list);
                            break;
                        }
                        case 3: {
                            schedulerAssocConfig = this.d.a((List<String>)object);
                            this.f.refreshRecord("schedulerAssoc", schedulerAssocConfig, list);
                            break;
                        }
                        default: {
                            return new OperationResponse(ResErrorCode.D);
                        }
                    }
                    break block37;
                }
                this.l.debug("no need to refresh ssid record.");
            }
            if (bl) {
                object = this.d.a((int)ssid.getIdInt(), ssid.getRateLimit(), ssid.getName(), ssid.getRadioId());
                this.a((SsidRateLimit)object, n2, com.tp_link.eap.d.b.a(), ssid.getWlanId());
            } else {
                this.l.debug("no need to refresh rate limit record.");
            }
        }
        object = new HashMap<String, String>();
        object.put("id", ssid.getId());
        return new OperationResponse(ResErrorCode.a, object);
    }

    @Override
    public OperationResponse getSsid(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.l.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("id");
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            return com.tp_link.eap.util.e.aZ;
        }
        Ssid ssid = this.getSsid(string);
        OperationResponse operationResponse = new OperationResponse(ResErrorCode.a);
        operationResponse.setResult((Object)ssid);
        return operationResponse;
    }

    @Override
    public OperationResponse getSsidByIndex(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.l.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        Integer n2 = jSONObject.optInt("ssidIndex");
        if (n2 == null) {
            return com.tp_link.eap.util.e.aZ;
        }
        Ssid ssid = this.getSsid(n2);
        OperationResponse operationResponse = new OperationResponse(ResErrorCode.a);
        operationResponse.setResult((Object)ssid);
        return operationResponse;
    }

    private OperationResponse a(Ssid ssid) {
        Object object;
        String string;
        ssid.setName(ssid.getName().trim());
        OperationResponse operationResponse = com.tp_link.eap.util.p.a.a((Validator)this.validator, (Object)ssid);
        if (!operationResponse.success()) {
            return operationResponse;
        }
        if (!com.tp_link.eap.util.l.j((String)ssid.getName())) {
            return new OperationResponse(ResErrorCode.as);
        }
        if (com.tp_link.eap.util.a.e.a((String)ssid.getWlanId())) {
            this.l.warn("Invalid empty wlanId");
            return com.tp_link.eap.util.e.aZ;
        }
        Ssid ssid2 = null;
        if (com.tp_link.eap.util.a.e.a((String)ssid.getId())) {
            ssid2 = new Ssid();
            ssid2.setBand(ssid.getBand());
            if (ssid.getBand().equalsIgnoreCase("5GHz")) {
                ssid2.setRadioId(1);
            } else {
                ssid2.setRadioId(0);
            }
            WlanGroup wlanGroup = this.i.findByWlanId(ssid.getWlanId());
            if (wlanGroup == null || wlanGroup.getRadioId().intValue() != ssid2.getRadioId()) {
                this.l.warn("Invalid wlanId, {}", (Object)(wlanGroup == null ? "wlanId is not exist" : "radio miss match"));
                return com.tp_link.eap.util.e.aZ;
            }
        } else {
            ssid2 = this.getSsid(ssid.getId());
        }
        int n2 = ssid2.getRadioId();
        String string2 = "";
        if (ssid.getSecurityMode() == 3 && ssid.getEncryptionPsk() == 2 || ssid.getSecurityMode() == 2 && ssid.getEncryptionEnt() == 2) {
            string2 = "tkip";
        } else if (ssid.getSecurityMode() == 1) {
            string2 = "wep";
        }
        if (!string2.equals("") && !(string = this.e.tkipAndWepCheck(n2, string2, ssid.getWlanId())).isSuccess()) {
            operationResponse = new OperationResponse(ResErrorCode.d);
            operationResponse.setMsg(string.getMessage());
            return operationResponse;
        }
        ssid2.setName(ssid.getName());
        string = ssid.getAccessControlRuleName();
        this.l.debug("bind rule: {}", (Object)string);
        ssid2.setAccessControlRuleName(string);
        if (!string.equals("None")) {
            object = this.c.findByGroupNameAndSite(string, com.tp_link.eap.d.b.a());
            ssid2.setAccessControlRule(object.getId());
            ssid2.setAccessControl(Boolean.valueOf(true));
        } else {
            ssid2.setAccessControlRule("None");
            ssid2.setAccessControl(Boolean.valueOf(false));
        }
        ssid2.setBroadcast(ssid.getBroadcast());
        ssid2.setIsolation(ssid.getIsolation());
        ssid2.setVlanId(ssid.getVlanId());
        ssid2.setWlanId(ssid.getWlanId());
        object = ssid.getSecurityMode();
        ssid2.setSecurityMode((Integer)object);
        block0 : switch ((Integer)object) {
            case 2: {
                ssid2.setVersionEnt(ssid.getVersionEnt());
                ssid2.setEncryptionEnt(ssid.getEncryptionEnt());
                ssid2.setRadiusPasswordEnt(ssid.getRadiusPasswordEnt());
                ssid2.setRadiusPort(ssid.getRadiusPort());
                ssid2.setRadiusServerIp(ssid.getRadiusServerIp());
                ssid2.setUpdatePeriodEnt(ssid.getUpdatePeriodEnt());
                break;
            }
            case 3: {
                ssid2.setVersionPsk(ssid.getVersionPsk());
                ssid2.setEncryptionPsk(ssid.getEncryptionPsk());
                ssid2.setWirelessPasswordPsk(ssid.getWirelessPasswordPsk());
                ssid2.setUpdatePeriodPsk(ssid.getUpdatePeriodPsk());
                break;
            }
            case 1: {
                ssid2.setWepMode(ssid.getWepMode());
                ssid2.setWepKeyIndex(ssid.getWepKeyIndex());
                switch (ssid.getWepKeyIndex()) {
                    case 1: {
                        ssid2.setWepKeyFormat1(ssid.getWepKeyFormat1());
                        ssid2.setWepKeyType1(ssid.getWepKeyType1());
                        ssid2.setWepKeyValue1(ssid.getWepKeyValue1());
                        break block0;
                    }
                    case 2: {
                        ssid2.setWepKeyFormat2(ssid.getWepKeyFormat2());
                        ssid2.setWepKeyType2(ssid.getWepKeyType2());
                        ssid2.setWepKeyValue2(ssid.getWepKeyValue2());
                        break block0;
                    }
                    case 3: {
                        ssid2.setWepKeyFormat3(ssid.getWepKeyFormat3());
                        ssid2.setWepKeyType3(ssid.getWepKeyType3());
                        ssid2.setWepKeyValue3(ssid.getWepKeyValue3());
                        break block0;
                    }
                    case 4: {
                        ssid2.setWepKeyFormat4(ssid.getWepKeyFormat4());
                        ssid2.setWepKeyType4(ssid.getWepKeyType4());
                        ssid2.setWepKeyValue4(ssid.getWepKeyValue4());
                        break block0;
                    }
                }
                return com.tp_link.eap.util.e.aZ;
            }
            case 0: {
                break;
            }
            default: {
                return new OperationResponse(ResErrorCode.y);
            }
        }
        ssid2.setRateLimit(ssid.getRateLimit());
        return this.saveSsid(ssid2, 1, true, null);
    }

    @Override
    public OperationResponse addSsid(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.l.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        Ssid ssid = (Ssid)JSONObject.toBean((JSONObject)jSONObject, Ssid.class);
        return this.a(ssid);
    }

    @Override
    public OperationResponse modifySsid(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.l.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        Ssid ssid = (Ssid)JSONObject.toBean((JSONObject)jSONObject, Ssid.class);
        return this.a(ssid);
    }

    private Ssid b(Ssid ssid) {
        Ssid ssid2 = this.a.findByNameAndSite(ssid.getName(), com.tp_link.eap.d.b.a());
        return ssid2;
    }

    public List<Ssid> getList(QueryPage queryPage) {
        List<Ssid> list = this.a.getByFilters(queryPage, null, null, null);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list;
    }

    public List<Ssid> getList(QueryPage queryPage, QuerySort querySort) {
        List<Ssid> list = this.a.getByFilters(queryPage, querySort, null, null);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list;
    }

    public List<Ssid> getList(QueryPage queryPage, List<QueryFilter> filters, List<QueryFilter> searcFilters) {
        List<Ssid> list = this.a.getByFilters(queryPage, null, filters, searcFilters);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list;
    }

    public List<Ssid> getList(QueryPage queryPage, QuerySort querySort, List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        List<Ssid> list = this.a.getByFilters(queryPage, querySort, filters, searchFilters);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list;
    }

    @Override
    public OperationResponse getGridSsid(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.l.warn("Invalid request, params is null.");
            return com.tp_link.eap.util.e.aZ;
        }
        QueryData queryData = (QueryData)JSONObject.toBean((JSONObject)jSONObject, QueryData.class);
        Grid grid = new Grid(queryData);
        if (queryData == null) {
            return com.tp_link.eap.util.e.aZ;
        }
        if (queryData.getSortName() == null || queryData.getSortName().equals("")) {
            queryData.setSortName("id");
        }
        grid.initSearch(queryData.getSearchKey(), new String[]{"name", "securityMode", "band"});
        grid.initFilters(queryData.getFilters());
        long l2 = this.count(grid.getFilters(), grid.getSearchFilters());
        grid.setTotalRows(l2);
        List list = this.getList(grid);
        if (list == null || list.isEmpty()) {
            OperationResponse operationResponse = new OperationResponse(ResErrorCode.a);
            operationResponse.setResult((Object)grid);
            return operationResponse;
        }
        ArrayList<SsidModel> arrayList = new ArrayList<SsidModel>();
        int n2 = queryData.getCurrentPage();
        int n3 = queryData.getCurrentPageSize();
        int n4 = (n2 - 1) * n3;
        int n5 = 1;
        for (Ssid ssid : list) {
            SsidModel ssidModel = new SsidModel();
            BeanUtils.copyProperties((Object)ssid, (Object)ssidModel);
            ssidModel.setIndex(n4 + n5++);
            ssidModel.setId(ssid.getId());
            ssidModel.setName(ssid.getName());
            ssidModel.setSecurityMode(ssid.getSecurityMode());
            ssidModel.setBand(ssid.getBand());
            ssidModel.setMacListId(ssid.getMacFilterId());
            ssidModel.setFilteringAction(ssid.getFilteringAction());
            ssidModel.setProfileId(ssid.getSchedulerId());
            ssidModel.setSchedulerAction(ssid.getSchedulerAction());
            ssidModel.setSetting("config&delete");
            if (ssid.getIsolation().booleanValue()) {
                ssidModel.setIsolation("enable");
            } else {
                ssidModel.setIsolation("disable");
            }
            if (ssid.portalIdExist().booleanValue()) {
                ssidModel.setPortal("enable");
            } else {
                ssidModel.setPortal("disable");
            }
            ssidModel.setRateLimit(ssid.getRateLimit());
            ssidModel.setAccessControl(ssid.getAccessControl());
            ssidModel.setAccessControlRuleName(ssid.getAccessControlRuleName());
            ssidModel.setWlanId(ssid.getWlanId());
            arrayList.add(ssidModel);
        }
        grid.setData(arrayList);
        OperationResponse operationResponse = new OperationResponse(ResErrorCode.a);
        operationResponse.setResult((Object)grid);
        return operationResponse;
    }

    public long count(List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        return this.a.getByFilters(null, null, filters, searchFilters).size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse delSsid(String id, boolean sendMessage) {
        if (id == null) {
            return com.tp_link.eap.util.e.aZ;
        }
        this.d.g();
        Integer n2 = 2;
        Integer n3 = 0;
        String string = com.tp_link.eap.d.b.a();
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            return new OperationResponse(ResErrorCode.r);
        }
        Object object = com.tp_link.eap.b.b.a.l((String)string);
        synchronized (object) {
            if (!this.k.siteNameAlreadyExist(string)) {
                this.l.warn("Invalid sitName.");
                com.tp_link.eap.b.b.a.m((String)string);
                return new OperationResponse(ResErrorCode.r);
            }
            Ssid ssid = (Ssid)this.a.findOne((Serializable)((Object)id));
            if (ssid == null) {
                return new OperationResponse(ResErrorCode.E);
            }
            if ("5GHz".equals(ssid.getBand())) {
                n3 = 1;
            }
            if (sendMessage) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(id);
                List<Ap> list = this.e.getSiteAndWlanAdoptedAps(com.tp_link.eap.d.b.a(), ssid.getWlanId());
                SsidConfig ssidConfig = this.d.a((int)n2, n3, arrayList);
                if (n3 == 0) {
                    this.f.refreshRecord("ssid_2G", ssidConfig, list);
                } else {
                    this.f.refreshRecord("ssid_5G", ssidConfig, list);
                }
            }
            this.a.delete((Serializable)((Object)id));
            this.e.refreshApSsid(ssid, n2);
        }
        return com.tp_link.eap.util.e.bd;
    }

    @Override
    public OperationResponse deleteSsid(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.l.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("id");
        return this.delSsid(string, true);
    }

    @Override
    public Ssid getSsid(String id) {
        return (Ssid)this.a.findOne((Serializable)((Object)id));
    }

    @Override
    public boolean deleteAll(boolean sendMessage) {
        this.a.deleteAll();
        List list = com.tp_link.eap.util.a.a.a(this.a.findAll());
        this.l.debug("after restore delete all : " + list);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            this.l.info("failed to delete some ssid entries, delete again");
            this.a.delete(list);
        }
        this.e.deleteAllSsidOverrides();
        return true;
    }

    @Override
    public Ssid getSsid(Integer idInt) {
        return this.a.findByIdInt(idInt);
    }

    @Override
    public Ssid getSsidByName(String name, String wlanId, Integer radioId) {
        return this.a.findByBandAndNameAndSiteAndWlanId(radioId == 0 ? "2.4GHz" : "5GHz", name, com.tp_link.eap.d.b.a(), wlanId);
    }

    @Override
    public boolean isTkipConfigured(int radioId, String wlanId) {
        List<Ssid> list = this.getSsidsByRadioIdAndWlanId(radioId, wlanId);
        if (CollectionUtils.isEmpty(list)) {
            return false;
        }
        for (Ssid ssid : list) {
            if ((ssid.getSecurityMode() != 3 || ssid.getEncryptionPsk() != 2) && (ssid.getSecurityMode() != 2 || ssid.getEncryptionEnt() != 2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isWepConfigured(int radioId, String wlanId) {
        List<Ssid> list = this.getSsidsByRadioIdAndWlanId(radioId, wlanId);
        if (CollectionUtils.isEmpty(list)) {
            return false;
        }
        for (Ssid ssid : list) {
            if (ssid.getSecurityMode() != 1) continue;
            return true;
        }
        return false;
    }

    @Override
    public void deleteBySite() {
        this.a.deleteBySite(com.tp_link.eap.d.b.a());
    }

    @Override
    public void deleteBySiteAndWlan(String wlanId) {
        if (null == wlanId) {
            return;
        }
        List<Ssid> list = this.a.findByWlanId(wlanId);
        if (!CollectionUtils.isEmpty(list)) {
            for (Ssid ssid : list) {
                this.delSsid(ssid.getId(), false);
            }
        }
    }

    @Override
    public List<Ssid> getDefSsidsByRadioId(Integer radioId) {
        WlanGroup wlanGroup = null;
        wlanGroup = radioId == 0 ? this.h.getDefWlanByRadioId(0) : this.h.getDefWlanByRadioId(1);
        if (wlanGroup != null) {
            return this.a.findByWlanId(wlanGroup.getWlanId());
        }
        return null;
    }

    @Override
    public List<Ssid> getSsidsByRadioIdAndWlanId(Integer radioId, String wlanId) {
        if (radioId == null || wlanId == null) {
            return null;
        }
        return this.a.findByRadioIdAndWlanId(radioId, wlanId);
    }

    @Override
    public List<Ssid> getAllBySite(String site) {
        return this.a.findBySiteOrderByIdAsc(site);
    }

    private boolean a(RateLimit rateLimit, RateLimit rateLimit2) {
        if (rateLimit == null || rateLimit2 == null) {
            return true;
        }
        if (rateLimit.isEnable() != rateLimit2.isEnable()) {
            return true;
        }
        if (rateLimit.getDownLimit() != rateLimit2.getDownLimit()) {
            return true;
        }
        return rateLimit.getUpLimit() != rateLimit2.getUpLimit();
    }

    /*
     * Enabled aggressive block sorting
     */
    private Integer a(Ssid ssid, Ssid ssid2, int n2) {
        if (ssid == null) {
            return 3;
        }
        int n3 = 0;
        if (!ssid2.getAccessControlRuleName().equals(ssid.getAccessControlRuleName())) {
            n3 = 1;
        }
        if (ssid2.getSchedulerId() != null && !ssid2.getSchedulerId().equals(ssid.getSchedulerId()) || ssid2.getSchedulerAction() != null && !ssid2.getSchedulerAction().equals(ssid.getSchedulerAction()) || ssid2.getMacFilterId() != null && !ssid2.getMacFilterId().equals(ssid.getMacFilterId()) || ssid2.getFilteringAction() != null && !ssid2.getFilteringAction().equals(ssid.getFilteringAction())) {
            n3 = 1;
        }
        if (n2 != 1 && (ssid2.getSchedulerId() == null || ssid2.getMacFilterId() == null)) {
            n3 = 1;
        }
        if (!ssid2.getBroadcast().equals(ssid.getBroadcast()) || !ssid2.getIsolation().equals(ssid.getIsolation()) || ssid2.getVlanId().intValue() != ssid.getVlanId().intValue() || ssid2.getSecurityMode().intValue() != ssid.getSecurityMode().intValue()) {
            n3 = 2;
        }
        switch (ssid2.getSecurityMode()) {
            case 2: {
                if (ssid2.getVersionEnt().intValue() == ssid.getVersionEnt().intValue() && ssid2.getEncryptionEnt().intValue() == ssid.getEncryptionEnt().intValue() && ssid2.getRadiusPasswordEnt().equals(ssid.getRadiusPasswordEnt()) && ssid2.getRadiusPort().intValue() == ssid.getRadiusPort().intValue() && ssid2.getRadiusServerIp().equals(ssid.getRadiusServerIp()) && ssid2.getUpdatePeriodEnt().intValue() == ssid.getUpdatePeriodEnt().intValue()) break;
                n3 = 2;
                break;
            }
            case 3: {
                if (ssid2.getVersionPsk().intValue() == ssid.getVersionPsk().intValue() && ssid2.getEncryptionPsk().intValue() == ssid.getEncryptionPsk().intValue() && ssid2.getWirelessPasswordPsk().equals(ssid.getWirelessPasswordPsk()) && ssid2.getUpdatePeriodPsk().intValue() == ssid.getUpdatePeriodPsk().intValue()) break;
                n3 = 2;
                break;
            }
            case 1: {
                if (ssid2.getWepMode().intValue() != ssid.getWepMode().intValue() || ssid2.getWepKeyIndex().intValue() != ssid.getWepKeyIndex().intValue()) {
                    n3 = 2;
                }
                switch (ssid2.getWepKeyIndex()) {
                    case 1: {
                        if (ssid2.getWepKeyFormat1().intValue() == ssid.getWepKeyFormat1().intValue() && ssid2.getWepKeyType1().intValue() == ssid.getWepKeyType1().intValue() && ssid2.getWepKeyValue1().equals(ssid.getWepKeyValue1())) break;
                        n3 = 2;
                        break;
                    }
                    case 2: {
                        if (ssid2.getWepKeyFormat2().intValue() == ssid.getWepKeyFormat2().intValue() && ssid2.getWepKeyType2().intValue() == ssid.getWepKeyType2().intValue() && ssid2.getWepKeyValue2().equals(ssid.getWepKeyValue2())) break;
                        n3 = 2;
                        break;
                    }
                    case 3: {
                        if (ssid2.getWepKeyFormat3().intValue() == ssid.getWepKeyFormat3().intValue() && ssid2.getWepKeyType3().intValue() == ssid.getWepKeyType3().intValue() && ssid2.getWepKeyValue3().equals(ssid.getWepKeyValue3())) break;
                        n3 = 2;
                        break;
                    }
                    case 4: {
                        if (ssid2.getWepKeyFormat4().intValue() == ssid.getWepKeyFormat4().intValue() && ssid2.getWepKeyType4().intValue() == ssid.getWepKeyType4().intValue() && ssid2.getWepKeyValue4().equals(ssid.getWepKeyValue4())) break;
                        n3 = 2;
                        break;
                    }
                }
                break;
            }
        }
        if (!ssid2.getName().equals(ssid.getName())) {
            n3 = 3;
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshRateLimitRecordByAp(Ap ap, SsidRateLimit srl, int radioId) {
        Object object;
        String string = ap.getMac();
        if (radioId == 1 && !com.tp_link.eap.util.e.a((DeviceMisc)ap.getDeviceMisc(), (String)ap.getModel())) {
            return;
        }
        SsidRateLimit ssidRateLimit = this.a(srl, radioId, ap);
        Object object2 = object = com.tp_link.eap.b.b.a.a((String)string);
        synchronized (object2) {
            SettingRecord settingRecord = this.f.getRecord(string, SettingRecord.SettingStatus.PENDING);
            if (settingRecord == null) {
                settingRecord = this.f.getRecord(string, SettingRecord.SettingStatus.BACKUP);
            }
            EapConfigBody eapConfigBody = new EapConfigBody();
            if (settingRecord == null) {
                if (radioId == 0) {
                    eapConfigBody.setLimits2G(Collections.singletonList(ssidRateLimit));
                } else {
                    eapConfigBody.setLimits5G(Collections.singletonList(ssidRateLimit));
                }
                SettingRecord settingRecord2 = new SettingRecord(string, com.tp_link.eap.util.a.b.a((Object)eapConfigBody), SettingRecord.SettingStatus.PENDING);
                this.f.refreshRecord(settingRecord2);
            } else {
                eapConfigBody = (EapConfigBody)com.tp_link.eap.util.a.b.a((String)settingRecord.getContent(), EapConfigBody.class);
                if (eapConfigBody == null) {
                    eapConfigBody = new EapConfigBody();
                    if (radioId == 0) {
                        eapConfigBody.setLimits2G(Collections.singletonList(srl));
                    } else {
                        eapConfigBody.setLimits5G(Collections.singletonList(srl));
                    }
                    SettingRecord settingRecord3 = new SettingRecord(string, com.tp_link.eap.util.a.b.a((Object)eapConfigBody), SettingRecord.SettingStatus.PENDING);
                    this.f.refreshRecord(settingRecord3);
                } else {
                    List list = null;
                    list = radioId == 0 ? eapConfigBody.getLimits2G() : eapConfigBody.getLimits5G();
                    if (CollectionUtils.isEmpty((Collection)list)) {
                        if (radioId == 0) {
                            eapConfigBody.setLimits2G(Collections.singletonList(ssidRateLimit));
                        } else {
                            eapConfigBody.setLimits5G(Collections.singletonList(ssidRateLimit));
                        }
                        settingRecord.setContent(com.tp_link.eap.util.a.b.a((Object)eapConfigBody));
                        this.f.refreshRecord(settingRecord);
                    } else {
                        List<SsidRateLimit> list2 = this.a(list, ssidRateLimit);
                        if (radioId == 0) {
                            eapConfigBody.setLimits2G(list2);
                        } else {
                            eapConfigBody.setLimits5G(list2);
                        }
                        settingRecord.setContent(com.tp_link.eap.util.a.b.a((Object)eapConfigBody));
                        this.f.refreshRecord(settingRecord);
                    }
                }
            }
        }
    }

    @Override
    public List<String> getSsidNameByPortalIdWithNull(String portalId) {
        return this.a.findSsidNameByPortalIdWithNull(portalId);
    }

    private void a(SsidRateLimit ssidRateLimit, int n2, String string, String string2) {
        List<Ap> list = this.e.getSiteAndWlanAdoptedAps(string, string2);
        if (!CollectionUtils.isEmpty(list)) {
            for (Ap ap : list) {
                this.refreshRateLimitRecordByAp(ap, ssidRateLimit, n2);
            }
        }
    }

    private List<SsidRateLimit> a(List<SsidRateLimit> list, SsidRateLimit ssidRateLimit) {
        boolean bl = false;
        ArrayList<SsidRateLimit> arrayList = new ArrayList<SsidRateLimit>(list);
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            SsidRateLimit ssidRateLimit2 = (SsidRateLimit)arrayList.get(i2);
            if (ssidRateLimit2.getId().intValue() != ssidRateLimit.getId().intValue()) continue;
            bl = true;
            ssidRateLimit2.setEnable(ssidRateLimit.getEnable());
            ssidRateLimit2.setDownLimit(ssidRateLimit.getDownLimit());
            ssidRateLimit2.setUpLimit(ssidRateLimit.getUpLimit());
            ssidRateLimit2.setSsidName(ssidRateLimit.getSsidName());
            ssidRateLimit2.setRadioId(ssidRateLimit.getRadioId());
            break;
        }
        if (!bl) {
            arrayList.add(ssidRateLimit);
        }
        return arrayList;
    }

    private SsidRateLimit a(SsidRateLimit ssidRateLimit, int n2, Ap ap) {
        List list;
        SsidRateLimit ssidRateLimit2 = new SsidRateLimit();
        ssidRateLimit2.setDownLimit(ssidRateLimit.getDownLimit());
        ssidRateLimit2.setUpLimit(ssidRateLimit.getUpLimit());
        ssidRateLimit2.setEnable(ssidRateLimit.getEnable());
        int n3 = ssidRateLimit.getId();
        ssidRateLimit2.setId(Integer.valueOf(n3));
        ssidRateLimit2.setRadioId(ssidRateLimit.getRadioId());
        ssidRateLimit2.setSsidName(ssidRateLimit.getSsidName());
        List list2 = list = n2 == 0 ? ap.getSsidOverrides() : ap.getSsidOverrides5g();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (SsidOverride ssidOverride : list) {
                if (ssidOverride.getIndex() != n3 || !ssidOverride.isEnable()) continue;
                this.l.debug("refresh rate limit with override info.");
                ssidRateLimit2.setSsidName(ssidOverride.getSsid());
                break;
            }
        }
        return ssidRateLimit2;
    }

    @Override
    public OperationResponse checkApRadioMode(int radioMode, int radioId, String wlanId) {
        if (radioMode == 2) {
            if (this.isTkipConfigured(radioId, wlanId)) {
                return new OperationResponse(ResErrorCode.ag);
            }
            if (this.isWepConfigured(radioId, wlanId)) {
                return new OperationResponse(ResErrorCode.ah);
            }
            if (this.j.isQoSWmmDisabled(radioId)) {
                return new OperationResponse(ResErrorCode.ai);
            }
        }
        if (radioMode == 8) {
            if (this.j.isQoSWmmDisabled(radioId)) {
                return new OperationResponse(ResErrorCode.aj);
            }
            if (this.isTkipConfigured(radioId, wlanId)) {
                return new OperationResponse(ResErrorCode.ak);
            }
            if (this.isWepConfigured(radioId, wlanId)) {
                return new OperationResponse(ResErrorCode.al);
            }
        }
        if (radioMode == 9) {
            if (this.j.isQoSWmmDisabled(radioId)) {
                return new OperationResponse(ResErrorCode.am);
            }
            if (this.isTkipConfigured(radioId, wlanId)) {
                return new OperationResponse(ResErrorCode.an);
            }
            if (this.isWepConfigured(radioId, wlanId)) {
                return new OperationResponse(ResErrorCode.ao);
            }
        }
        return com.tp_link.eap.util.e.bd;
    }

    @Override
    public OperationResponse saveMacFilterAssociation(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.l.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        MacFilterAssociationInfo macFilterAssociationInfo = (MacFilterAssociationInfo)JSONObject.toBean((JSONObject)jSONObject, MacFilterAssociationInfo.class);
        if (macFilterAssociationInfo.getFilterAction() == null) {
            return new OperationResponse(ResErrorCode.d);
        }
        Ssid ssid = this.getSsid(macFilterAssociationInfo.getId());
        if (ssid == null) {
            return new OperationResponse(ResErrorCode.d);
        }
        ssid.setMacFilterId(macFilterAssociationInfo.getMacListId());
        ssid.setFilteringAction(macFilterAssociationInfo.getFilterAction());
        return this.saveSsid(ssid, 2, true, null);
    }

    @Override
    public OperationResponse saveSchedulerAssociation(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.l.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        SchedulerAssociationInfo schedulerAssociationInfo = (SchedulerAssociationInfo)JSONObject.toBean((JSONObject)jSONObject, SchedulerAssociationInfo.class);
        if (schedulerAssociationInfo.getSchedulerAction() == null) {
            return new OperationResponse(ResErrorCode.d);
        }
        Ssid ssid = this.getSsid(schedulerAssociationInfo.getId());
        if (ssid == null) {
            return new OperationResponse(ResErrorCode.d);
        }
        ssid.setSchedulerId(schedulerAssociationInfo.getProfileId());
        ssid.setSchedulerAction(schedulerAssociationInfo.getSchedulerAction());
        return this.saveSsid(ssid, 3, true, null);
    }

    @Override
    public OperationResponse getSsidNameList(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.l.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("portalId");
        List<String> list = this.getSsidNameByPortalIdWithNull(string);
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        hashMap.put("data", list);
        return new OperationResponse(ResErrorCode.a, hashMap);
    }
}

